/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.net.LocalServerSocket;
import com.ibm.hwmca.fw.net.LocalSocket;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NativeProcess {
    public static final int SIGHUP = 1;
    public static final int SIGINT = 2;
    public static final int SIGQUIT = 3;
    public static final int SIGKILL = 9;
    public static final int SIGUSR1 = 10;
    public static final int SIGUSR2 = 12;
    public static final int SIGTERM = 15;
    public static final int SIGSTOP = 19;
    private static final String TRACE_MASKT = "XNPRJNPT";
    private static final String TRACE_MASKF = "XNPRJNPF";
    int pid = -1;
    boolean orphan;
    int exitValue;
    boolean processEnded;
    IOException processTerminationException;
    private static boolean trackingListenerStarted;
    private static Object childPidToNativeProcessMapLock;
    private static Map childPidToNativeProcess;
    private static String childListeningSocketPath;
    private static LocalServerSocket listeningSocket;
    private static final int REPORT_PROCESS_EXITED_NORMALLY = 78;
    private static final int REPORT_PROCESS_ENDED_DUE_TO_SIGNAL = 83;
    private static final int REPORT_SHEPHERD_ERROR = 69;

    protected NativeProcess(int pid, boolean orphan) {
        Trace.trace(TRACE_MASKT, "Instantiating NativeProcess object " + this.toString() + " for pid " + pid);
        this.pid = pid;
        this.orphan = orphan;
        if (!orphan) {
            NativeProcess.trackRunningChild(pid, this);
        }
    }

    private static native void staticNativeInit();

    public static native NativeProcess exec(NativeProcessParameters var0) throws IOException;

    public synchronized int waitFor() throws InterruptedException {
        if (this.orphan) {
            throw new IllegalStateException("Cannot wait on an orphan process");
        }
        Trace.trace(TRACE_MASKT, "Waiting for native process " + this.toString() + "(pid==" + this.pid + ") to end.");
        while (!this.processEnded) {
            this.wait();
        }
        return this.exitValue();
    }

    public synchronized int exitValue() {
        if (this.orphan) {
            throw new IllegalStateException("Cannot get exit value for an orphan process");
        }
        if (!this.processEnded) {
            throw new IllegalThreadStateException("Process has not yet ended");
        }
        return this.exitValue;
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "Destroying native process " + this.toString() + "(pid==" + this.pid + ")");
        this.signal(15);
    }

    public native void signal(int var1);

    public native void signalProcessGroup(int var1);

    private static synchronized void ensureTrackingListenerStarted() throws IOException, HException {
        if (trackingListenerStarted) {
            return;
        }
        trackingListenerStarted = true;
        String dir = BaseFileControl.getFilePath("domainsocket");
        new File(dir).mkdirs();
        childListeningSocketPath = dir + "nativeProcessChildrenListener";
        LocalServerSocket.removeSocket(childListeningSocketPath);
        listeningSocket = new LocalServerSocket(childListeningSocketPath);
        Thread listener = new Thread(new Runnable(){

            public void run() {
                NativeProcess.trackChildren();
            }
        }, "Native Process listener for tracking children");
        listener.setDaemon(true);
        listener.start();
    }

    private static void trackChildren() {
        Trace.trace(TRACE_MASKT, "Listening for native process endings.");
        while (true) {
            LocalSocket clientSocket;
            try {
                clientSocket = listeningSocket.accept();
            }
            catch (IOException e) {
                System.err.println("Error accepting Native Process children socket connection.");
                e.printStackTrace();
                continue;
            }
            NativeProcess.processChildResult(clientSocket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processChildResult(LocalSocket clientSocket) {
        try {
            Trace.trace(TRACE_MASKT, "Processing native process completion");
            DataInputStream in = new DataInputStream(new BufferedInputStream(clientSocket.getInputStream()));
            int pid = in.readInt();
            NativeProcess nativeProcess = NativeProcess.getNativeProcessFromPid(pid);
            if (nativeProcess == null) {
                throw new IOException("Received termination information on unknown child with pid==" + pid);
            }
            int status = in.readInt();
            switch (status) {
                case 78: {
                    nativeProcess.exitValue = in.readInt();
                    Trace.trace(TRACE_MASKT, "NativeProcess " + nativeProcess.toString() + ": child with pid==" + pid + " exited normally with status==" + nativeProcess.exitValue);
                    break;
                }
                case 83: {
                    nativeProcess.exitValue = in.readInt() + 128;
                    Trace.trace(TRACE_MASKT, "NativeProcess " + nativeProcess.toString() + ": child with pid==" + pid + " exited due to signal " + (nativeProcess.exitValue - 128));
                    break;
                }
                case 69: {
                    String message = in.readUTF();
                    nativeProcess.processTerminationException = new IOException("Error starting process: " + message);
                    Trace.trace(TRACE_MASKT, "NativeProcess " + nativeProcess.toString() + ": child with pid==" + pid + " exited with error \"" + message + "\"");
                }
            }
            NativeProcess nativeProcess2 = nativeProcess;
            synchronized (nativeProcess2) {
                nativeProcess.processEnded = true;
                nativeProcess.notifyAll();
            }
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "IOException processing a Native Process child socket connection:");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeProcess getNativeProcessFromPid(int pid) {
        Object object = childPidToNativeProcessMapLock;
        synchronized (object) {
            return (NativeProcess)childPidToNativeProcess.remove(new Integer(pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trackRunningChild(int pid, NativeProcess nativeProcess) {
        Object object = childPidToNativeProcessMapLock;
        synchronized (object) {
            childPidToNativeProcess.put(new Integer(pid), nativeProcess);
            Trace.trace(TRACE_MASKT, "Tracking new child with pid==" + pid + " for NativeProcess " + nativeProcess.toString());
        }
    }

    static {
        childPidToNativeProcessMapLock = new Object();
        childPidToNativeProcess = new HashMap();
        try {
            System.loadLibrary("jniNativeProcess");
            NativeProcess.staticNativeInit();
            NativeProcess.ensureTrackingListenerStarted();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Unable to load native method library \"jniNativeProcess\":" + e);
        }
        catch (IOException e) {
            System.err.println("Error creating Native Process children listening socket: " + e);
        }
        catch (HException e) {
            System.err.println("Error creating Native Process children listening socket: " + e);
        }
    }
}

